--
-- V01.01 - 2011-12-01 - dcn
--
-- Master CLEAN_Address installation script
-- 
--SQLDBPATH = "C:\Clean_Address_ssSQLCLR\Data\" 
--SQLCLRBIN = "C:\CLEAN_Assddress_SQLCLR\bin\"
--CLNADRHOST = "http://localhost:8097/CLNVerify"
--PSUSER = 'dcntest'
use master

set nocount on

go

:On Error Exit
--
declare @FileIsDirectory bit
create table #a(FileExists bit, FileIsDirectory bit, ParentDirectoryExists bit)
--
-- Verify SQLDBPATH from batch file
--
insert #a exec master..xp_fileexist '$(SQLDBPATH)'

select @FileIsDirectory = FileIsDirectory from #a

If @FileIsDirectory = 0
  Begin
	Print 'SQLDBPATH does not exist: $(SQLDBPATH), install aborted.'
	drop table #a
	return
  End
else
  begin
	Declare @t as nvarchar(200)
	Set @t = '$(SQLDBPATH)'
	 
	if SUBSTRING(@t,len(@t),1) <> '\'	
		begin
			print 'SQLDBPATH should end with a backslash "\" character, install aborted.'
			drop table #a
			return
		end
	Print '...SQLDBPATH Verified.'
  end
 --
-- Verify SQLCLRBIN from batch file
--
insert #a exec master..xp_fileexist '$(SQLCLRBIN)'

select @FileIsDirectory = FileIsDirectory from #a

If @FileIsDirectory = 0
  Begin
	Print 'SQLCLRBIN does not exist: $(SQLCLRBIN), install aborted.'
	drop table #a
	return
  End
else
  begin
	Declare @t1 as nvarchar(200)
	Set @t1 = '$(SQLCLRBIN)'
	 
	if SUBSTRING(@t1,len(@t1),1) <> '\'	
		begin
			print 'SQLCLRBIN should end with a backslash "\" character, install aborted.'
			drop table #a
			return
		end
	Print '...SQLCLRBIN Verified.'
  end
    
drop table #a

print 'Command verification completed.. installation continuing.'

Print '01_CLEAN_Address_DBProcs.sql starting, CLEAN_Address db and related objects.'
:r 01_CLEAN_Address_DBProcs.sql

use [CLEAN_Address]

Print '02_Verify_Address_AJAX.sql'
:r 02_Verify_Address_AJAX.sql

if ISNULL('$(PSUSER)','') <> '' and ISNULL('$(PSUSER)','') <> 'sa'
  Begin
		Print '99_OptionalGrantPermissions.sql starting for user $(PSUSER)'
		:r 99_OptionalGrantPermissions.sql
  end
 
Print 'CLEAN_Address SQL CLR installation completed.'

--
set nocount off

go